#ifndef ILD_WILDCARD_H
#define ILD_WILDCARD_H

#include <vector>
#include <utility>
#include <iosfwd>
#include "config.h"
#include "cpluslib/string.h"

class Wildcard {
    enum Opcode {
        MATCH_SEQ,              // '*'
        MATCH_SINGLE,           // '?'
        MATCH_RANGE,            // '[foo]', string = list of chars
        MATCH_NOT,              // '[^foo]', string = list of chars
        MATCH_LIT               // 'foo', string = literal
    };
    typedef std::pair<Opcode, string_t> insn_type;
    typedef std::vector<insn_type> code_type;

    code_type code;

    bool matchInternal(string_t s, code_type::size_type n);
 public:
    Wildcard();
    Wildcard(string_t re);
    ~Wildcard();

    bool setExpr(string_t re);
    void setLiteral(string_t re);

    bool match(string_t s);
    string_t getPrefix() const;

#ifdef DEBUG
    void dump(std::ostream& os);
#endif
};

#endif
