/**
  *  \file vfile.h
  *  \brief View on a File
  */
#ifndef ILD_VFILE_H
#define ILD_VFILE_H

#include <map>
#include "file.h"
#include "cpluslib/smartptr.h"

class VFile {
    Ptr<File> file;
    off_t start;
    off_t size;
    time_t mtime;
 public:
    VFile(Ptr<File> afile, off_t astart, off_t asize);

    ssize_t read(off_t where, void* buffer, size_t count);
    ssize_t write(off_t where, const void* buffer, size_t count);

    time_t getMtime() const { return mtime; }
    void setMtime(time_t am) { mtime = am; }
    void setMtime() { mtime = file->getMtime(); }

    Ptr<VFile> getSubFile(off_t awhere, size_t acount);
};

void copyFileRegion(VFile& f, off_t from, off_t to, std::size_t count);

#endif
