#!/usr/bin/perl
#
#  Generate `names.inc', the file used to map ELF values to symbolic
#  constants. Reads & "parses" `elf.h'.
#
#  The `SHT_xxx' constants will be available in an array named
#  `sht_names', and so on.
#

#open ELF, "</usr/include/linux/elf.h" or die;
open ELF, "<elf.h" or die;
while(<ELF>) {
    if(/^\#define\s+([A-Z0-9]+)_([A-Z_0-9a-z]+)\s+([0-9xa-fA-F]+)/) {
	my $cat = $1;
	my $sym = $2;
	my $val = $3;
	$data{$cat}{$sym} = $val;
    }
}
close ELF;

foreach $i (sort keys %data) {
    print "NameMap ", lc($i), "_names[] = {\n";
    foreach $j (sort keys %{$data{$i}}) {
	print "\t\{ \"${i}_$j\",\t$data{$i}{$j} \},\n";
    }
    print "\t{ 0, 0 },\n";
    print "};\n\n";
}
