/**
  *  \file parse.h
  */
#ifndef ILD2_PARSE_H
#define ILD2_PARSE_H

#include <cstddef>
#include "cpluslib/string.h"
#include "cpluslib/types.h"

uint32 parseNumberHelper(const char* n, std::size_t max, int base);
void storeNumberHelper(char* n, std::size_t max, int base, uint32 num);
void storeStringHelper(char* n, std::size_t max, const char* src);

template<int N>
uint32 parseNumber(char (&n)[N], int base) { return parseNumberHelper(n, N, base); }
template<int N>
uint32 parseNumber(char const (&n)[N], int base) { return parseNumberHelper(n, N, base); }

template<int N>
void storeNumber(char (&n)[N], int base, uint32 num) { storeNumberHelper(n, N, base, num); }

template<int N>
void storeString(char (&n)[N], const char* src) { storeStringHelper(n, N, src); }

string_t quoteFilename(string_t fn);
string_t unquoteFilename(string_t fn);
void parseFilename(string_t in, string_t& filename, string_t& member);

#endif
