#ifndef ILD_PARAM_H
#define ILD_PARAM_H

#include <vector>
#include "cpluslib/string.h"

enum LinkMode {
    LM_NORMAL,                  /* normal mode, "tight" */
    LM_INCREM_FIRST,            /* first "incremental" link */
    LM_INCREM                   /* subsequent incremental link */
};

/* linker mode */
extern LinkMode link_mode;

/* library search path */
extern std::vector<string_t> lib_path;

/* name of start symbol */
extern string_t start_symbol;

/* output file name */
extern string_t output_file;

/* state file name */
extern string_t state_file;

/* create a state file? */
extern bool state_file_p;

/* dynamic link? */
extern bool dynamic_link;

void addLibDir(string_t s);
void addLibPath(string_t s);

#endif
