#include <algorithm>
#include "param.h"

/* linker mode */
LinkMode link_mode = LM_NORMAL;

/* library search path */
std::vector<string_t> lib_path;

/* name of start symbol */
string_t start_symbol = "_start";

/* output file name */
string_t output_file = "ild.out";

/* state file name */
string_t state_file;

/* create a state file? */
bool state_file_p = true;

/* dynamic link? */
// FIXME: dynamic linking is not yet supported
bool dynamic_link = false;

// Add a directory to the library path, unless it is already there.
void
addLibDir(string_t s)
{
    if(std::find(lib_path.begin(), lib_path.end(), s) == lib_path.end())
        lib_path.push_back(s);
}

// Add a colon-separated list of directories to the library path.
void
addLibPath(string_t s)
{
    for(string_split_iterator i(s, ":"); i != string_split_iterator(); ++i)
        addLibDir(*i);
}
