/**
  *  \file output.h
  */
#ifndef ILD2_OUTPUT_H
#define ILD2_OUTPUT_H

#include <set>

#include "elf.h"
#include "file.h"

class Output {
    Output operator=(const Output&);
    Output(const Output&);
 public:
    Output() { }
    virtual ~Output() {}

    virtual void startOutput(Elf32_Addr start, Elf32_Addr first) = 0;
    virtual void writeOutput(void*       data,
                             Elf32_Addr  address,
                             Elf32_Word  data_size,
                             Elf32_Word  vm_size,
                             int         prot) = 0;
    virtual void endOutput() = 0;
};

class DefaultOutput : public Output {
    struct PhdrCompare {
        bool operator()(const Elf32_Phdr& a, const Elf32_Phdr& b) {
            return a.p_vaddr < b.p_vaddr;
        }
    };
    /* Set of program headers */
    typedef std::set<Elf32_Phdr, PhdrCompare> ph_set;
    
    /* Output file */
    File        file;
    /* ELF file header */
    Elf32_Ehdr  header;
    /* First virtual address that appear in file use */
    Elf32_Word  first_vaddr;
    /* Offset corresponding to that address */
    Elf32_Word  first_offset;
    /* Program headers */
    ph_set      pheaders;
    string_t    filename;

    void mergePhdrs();
 public:
    DefaultOutput(string_t afilename);
    ~DefaultOutput();
    void writeOutput(void* data,
                     Elf32_Addr address,
                     Elf32_Word data_size,
                     Elf32_Word vm_size,
                     int prot);
    void startOutput(Elf32_Addr start, Elf32_Addr first);
    void endOutput();
};

#endif
