#include <cstdio>
#include "namemap.h"

// Format /value/ using name map /map/, as an enumeration member.
string_t getName(NameMap* map, Elf32_Word value)
{
    while(map->name) {
        if(value == map->value)
            return map->name;
        map++;
    }

    return itox(value);
}

// Format /value/ using name map /map/, as a bitfield. The result is
// a string containing bitwise or of /map/ items, e.g. "FOO | BAR".
string_t getBitfield(NameMap* map, Elf32_Word value)
{
    string_t result;
    while(map->name) {
        if(value & map->value) {
            if(result.length())
                result += " | ";
            result += map->name;
            value &= ~map->value;
        }
        map++;
    }

    if(value) {
        if(result.length())
            result += " | ";
        return result + itox(value);
    } else {
        if(result.length())
            return result;
        else
            return "0";
    }
}

// Convert /value/ to hexadecimal string.
string_t itox(Elf32_Word value)
{
    char buf[50];
    std::sprintf(buf, "0x%x", (unsigned int)value);
    return buf;
}

// Convert /value/ to decimal string.
string_t itoa(Elf32_Word value)
{
    char buf[50];
    std::sprintf(buf, "%d", (int)value);
    return buf;
}
