#ifndef ILD_LOG_H
#define ILD_LOG_H

#include <iosfwd>
#include "cpluslib/string.h"

enum LogLevel {
    LOG_DEBUG,
    LOG_INF,
    LOG_WARN,
    LOG_ERROR
};

extern LogLevel log_level;

std::ostream& log(LogLevel l);
bool wantLog(LogLevel l);
void perror(string_t message, LogLevel l = LOG_ERROR);

#endif
