#include <fstream>
#include <cstdio>
#include <cstring>
#include <cerrno>
#include <iostream>
#include "log.h"
#include "config.h"
#include "cpluslib/string.h"

static std::ofstream null("/dev/null");
static const char* log_names[] = {
    "DEBUG: ",
    "INF: ",
    "WARN: ",
    "ERROR: "
};

LogLevel log_level = LOG_DEBUG;

std::ostream& log(LogLevel l)
{
    return (l >= log_level) ? (std::cerr << log_names[l]) : null;
}

bool wantLog(LogLevel l)
{
    return l >= log_level;
}

void perror(string_t s, LogLevel l)
{
    if(wantLog(l)) {
        // 17.3.1.2 p5: errno is a macro, not a member of std, so all
        // are happy.
        string_t msg = std::strerror(errno);
        std::cerr << s << ": " << msg << std::endl;
    }
}
