#include <iostream>
#include <cstdio>
#include <fcntl.h>
#include "iar-d.h"
#include "iar.h"
#include "archive.h"
#include "vfile.h"
#include "log.h"
#include "cpluslib/assert.h"
#include "except.h"
#include "cpluslib/types.h"
#include "parse.h"

/*
 *  `$AR d libc.a msgcat.o'
 *  iar:      0.160 real
 *  GNU ar:   0.910 real
 */

/*
 *  Delete Archive Members
 *
 *  Deleting is easy.
 */
void
iarDeleteArchiveMembers()
{
    if(file_names.empty()) {
        std::cerr << "No member file name specified\n";
        return;
    }

    /* open archive */
    Ptr<File> f = new File(arch_name, O_RDWR);
    if(!f->isOpen())
        throw LinkerError(string_t("Can't open `") + arch_name + "': " +
                          f->openErrorMessage());

    Archive arch(new VFile(f, 0, -1), true);

    /* delete members */
    for(std::vector<const char*>::iterator fn_iter = file_names.begin();
        fn_iter != file_names.end(); ++fn_iter) {
        Archive::MPtr mptr = arch.getMemberByName(*fn_iter);
        if(mptr.ptr()) {
            /* if the file name was a long one, this leaves an unused
               entry in the LFN table. This should not disturb anyone,
               and changing it would possibly require rewriting the
               whole archive directory */
            mptr->type = Archive::M_PAD;
            mptr->dirty = true;
            // FIXME: delete it from by_name(?)
            arch.changeArmapEntry(mptr->pos, 0);
        } else
            std::cerr << "no entry " << *fn_iter << " in archive\n";
    }

    /* update archive */
    log(LOG_DEBUG) << "updating armap...\n";
    arch.updateArmap();
    log(LOG_DEBUG) << "compacting directory...\n";
    arch.compactDirectory();

    log(LOG_DEBUG) << "saving headers...\n";
    arch.saveHeaders();
}

