/**
  *  \file got.h
  */
#ifndef ILD2_GOT_H
#define ILD2_GOT_H

#include <list>
#include "section.h"

class Output;
class StateFileWriter;

class GlobalOffsetTable : public ProgramSection {
    typedef std::list<string_t> list_type;
    list_type entries;
 public:
    GlobalOffsetTable();
    ~GlobalOffsetTable();
    Elf32_Word addEntry(const string_t& s);
    void writeOutput(Output& out);
    void writeGotStateFile(StateFileWriter& w);
};

#endif
