#ifndef ILD_GETOPT_H
#define ILD_GETOPT_H

/*
 *  Option Parser
 */

#include "cpluslib/string.h"

#define OPTION(x) (((unsigned char)-1) + (x))

struct Option {
    char        short_name;     // short name of option or 0
    const char* long_name;      // long name of option or 0
    bool        arg;            // true iff option requires argument
    int         ret_val;        // return value

    struct iterator;
    struct Error;
};

class Option::iterator {
    const Option* defs;
    char** argv;
    const char* argp;
    bool stopped;
    
    void next();
 public:
    iterator();                 // EOF iterator
    iterator(char** aargv, const Option* adefs);     // start iterator

    iterator& operator++() {
        next();
        return *this;
    }
    iterator operator++(int) {
        iterator ret = *this;
        operator++();
        return ret;
    }

    bool operator==(const iterator& rhs) const {
        return argv == rhs.argv && argp == rhs.argp;
    }
    bool operator!=(const iterator& rhs) const { return !operator==(rhs); }

    void stop() { stopped = true; }
    bool hasMoreElements() const { return argv || argp; }

    int id;                     // option id (0 if plain argument)
    const char* arg;            // argument if present
};

class Option::Error {
 public:
    string_t msg;
    Error(string_t amsg)
        : msg(amsg) { }
};

#endif
