/**
  *  \file file.h
  *  \brief Stateless Unbuffered POSIX File I/O
  *
  *  This module provides a lightweight wrapper around POSIX file I/O.
  */
#ifndef ILD_FILE_H
#define ILD_FILE_H

#include <string>
#include <sys/types.h>
#include <unistd.h>
#include "cpluslib/string.h"

class File {
    File& operator=(const File&);
    File(const File&);

    int fd;
    int open_errno;
 public:
    File(const char* filename, int flags);
    File() : fd(-1) { }
    ~File();
    bool open(const char* filename, int flags);
    bool create(const char* filename, int mode);
    void close();
    bool isOpen() const { return fd >= 0; }

    ssize_t read(off_t where, void* buffer, size_t count);
    ssize_t write(off_t where, const void* buffer, size_t count);

    int chmod(mode_t mode);
    int fstat(struct stat& buf);

    time_t getMtime();

    string_t openErrorMessage();
    int getOpenErrno() const { return open_errno; }

    static unsigned long bytes_read, bytes_written;

    static int fixMode(int mode);
};

#endif
