/**
  *  \file closure.h
  */
#ifndef ILD2_CLOSURE_H
#define ILD2_CLOSURE_H

/*** Closures *********************************************************/

#define DECLARE_CLOSURES(NUM, CLASS, TYPES, ARGS, CALL)                   \
template<CLASS, class R>                                                  \
struct Callee##NUM {                                                      \
    virtual R call(TYPES) const { };                                      \
    virtual ~Callee##NUM() { }                                            \
};                                                                        \
                                                                          \
template<CLASS, class R, class Class>                                     \
class Closure##NUM : public Callee##NUM<TYPES, R> {                       \
    Class* c;                                                             \
    R (Class::*func)(TYPES);                                              \
 public:                                                                  \
    Closure##NUM(Class* ac, R (Class::*afunc)(TYPES)) : c(ac), func(afunc) { } \
    R call(ARGS) const { return (c->*func)(CALL); }                       \
};                                                                        \
                                                                          \
template<CLASS, class R>                                                  \
class Function##NUM : public Callee##NUM<TYPES, R> {                      \
    R (*func)(TYPES);                                                     \
 public:                                                                  \
    Function##NUM(R (*afunc)(TYPES)) : func(afunc) { }                    \
    R call(ARGS) const { return (*func)(CALL); }                          \
};                                                                        \
                                                                          \
template<CLASS, class R, class Class>                                     \
inline Closure##NUM<TYPES, R, Class> call(Class* ac, R (Class::*afunc)(TYPES)) \
{                                                                         \
    return Closure##NUM<TYPES, R, Class>(ac, afunc);                      \
}                                                                         \
                                                                          \
template<CLASS, class R>                                                  \
inline Function##NUM<TYPES, R> call(R (*afunc)(TYPES))                    \
{                                                                         \
    return Function##NUM<TYPES, R>(afunc);                                \
}

#define AND ,
DECLARE_CLOSURES(2, class A AND class B, A AND B, A a AND B b, a AND b)
DECLARE_CLOSURES(1, class A,             A,       A a,         a)
#undef AND
#undef DECLARE_CLOSURES

#endif
