/**
  *  \file testsset.cc
  */

#include "cpluslib/smallset.h"

#include <iostream>
#include <cassert>

enum Numbers { One, Two, Three };

typedef SmallSet<Numbers> Num_set;

int main()
{
    Num_set e;
    Num_set s1(One), s2(Two), s3(Three);

    assert(e.empty());
    assert(!s1.empty());
    assert(!s2.empty());
    assert(!s3.empty());

    assert(s1.contains(One));
    assert(!s1.contains(Two));
    assert(!s1.contains(Three));

    assert((s1 + s2).contains(One));
    assert(!(s1 + s2).contains(Three));
    assert((s1 + s2).contains(s1));
    assert((s1 + s2).contains(s2));
    assert(!(s1 + s2).contains(s3));

    assert(s1 != s2);
    assert(s1 + Two - One == s2);

    Num_set n(s1);
    n += Two;
    assert(n.containsAnyOf(s1));
    assert(n.contains(s1));
    assert(!s1.contains(n));

    assert((n ^ s1) == s2);
    assert((s1 ^ s2) == n);
    assert((n ^ s2) == s1);

    assert((s1 & s2).empty());
    assert(!(s1 - s2).empty());

    assert((n - s2) == s1);
}
