/**
  *  \file testmaybe.cc
  */

#include "cpluslib/maybe.h"

#include <iostream>
#include "cpluslib/types.h"

typedef SimpleMaybe<int16,0x8000> may16;
typedef SimpleMaybe<uint16,0xFFFF> umay16;

int
main()
{
    may16 a, b(99), c(20);
    std::cout << a.getRawValue() << ", " << b << ", " << c << "\n";
    std::cout << a.isKnown() << ", " << b.isKnown() << ", " << c.isKnown() << "\n";
    std::cout << (b*c) << "\n";
    a = may16(b+1);
    std::cout << a << "\n";

    umay16 d;
    std::cout << d.getRawValue() << "\n";
    // d = umay16(c);        does not compile
    d = umay16(c.getValue());
    std::cout << d << " = " << c << "\n";

    return 0;
}
