#include "cpluslib/format.h"

#include <iostream>
#include "cpluslib/string.h"

void tester()
{
    string_t s = format("foo%d") << 42;
}

void second_tester()
{
    string_t s = format("foo%d", 42);
}

int main()
{
    std::cout << (format("dezimal            = `%d'\n") << 42);
    std::cout << (format("hex                = `%x'\n") << 42);
    std::cout << (format("oct                = `%o'\n") << 42);
    std::cout << (format("alt.hex            = `%#x'\n") << 42);
    std::cout << (format("alt.oct            = `%#o'\n") << 42);
    std::cout << (format("alt.dezimal        = `%#d'\n") << 42);
    std::cout << (format("group dez          = `%'d'\n") << 42);
    std::cout << (format("group oct          = `%'o'\n") << 42);
    std::cout << (format("10-dez             = `%10d'\n") << 42);
    std::cout << (format("left 10-dez        = `%-10d'\n") << 42);
    std::cout << (format("left group 10-dez  = `%'-10d'\n") << 42);
    std::cout << (format("group 10-dez       = `%'10d'\n") << 42);
    std::cout << (format("zpad 10-dez        = `%010d'\n") << 42);
    std::cout << (format("sign zpad 10-dez   = `%+010d'\n") << 42);
    std::cout << (format("group 10-dez       = `%'10d'\n") << 1024);
    std::cout << (format("group 10-dez       = `%'10d'\n") << 45054);
    std::cout << (format("group 10-hex       = `%'10X'\n") << 45054);
    std::cout << (format("group alt 10-hex   = `%#'10X'\n") << 45054);
    std::cout << (format("group alt 10 dez   = `%#'10X'\n") << 999);
    std::cout << (format("group alt neg dez  = `%#'d'\n") << -999);
    std::cout << (format("group alt neg10dez = `%#'10d'\n") << -999);
    std::cout << (format("zpad alt neg10dez  = `%#010d'\n") << -999);
    std::cout << (format("neg 10 dez         = `%#10d'\n") << -4711);
    std::cout << (format("left neg 10 dez    = `%-#10d'\n") << -4711);
    std::cout << (format("grp neg dez        = `%'d'\n") << -4711);
    for (int n = 0; n < 3; ++n)
        for (int price = 0; price < 3; ++price)
            std::cout << (format("cond = `%d %1{item for %d dollar%!1{s%}%|"
                                 "items for %d dollar%!1{s%} each%}'\n") << n << price);

    /* floating-point tests */
    std::cout << (format("format e           = `%e'\n") << 4711.0);
    std::cout << (format("format f           = `%f'\n") << 4711.0);
    std::cout << (format("format g           = `%g'\n") << 4711.0);
    std::cout << (format("format e one       = `%e'\n") << 1.0);
    std::cout << (format("format f one       = `%f'\n") << 1.0);
    std::cout << (format("format g one       = `%g'\n") << 1.0);
    std::cout << (format("format e zero      = `%e'\n") << 0.0);
    std::cout << (format("format f zero      = `%f'\n") << 0.0);
    std::cout << (format("format g zero      = `%g'\n") << 0.0);
    std::cout << (format("format e tiny      = `%e'\n") << 0.00000123);
    std::cout << (format("format f tiny      = `%f'\n") << 0.00000123);
    std::cout << (format("format g tiny      = `%g'\n") << 0.00000123);
    std::cout << (format("format .2g         = `%.2g'\n") << 12345.0);

    /* more floating-point tests */
    std::cout << (format("format .2f .999     = `%.2f'\n") << 0.999);
    std::cout << (format("format .2e .999     = `%.2e'\n") << 0.999);
    std::cout << (format("format .2f 99.999   = `%.2f'\n") << 99.999);
    std::cout << (format("format .2e 99.999   = `%.2e'\n") << 99.999);
    std::cout << (format("format .5f 99.999   = `%.5f'\n") << 99.999);
    std::cout << (format("format .5e 99.999   = `%.5e'\n") << 99.999);
    std::cout << (format("format .2f 25       = `%.2f'\n") << 25.0);
    std::cout << (format("format .2e 25       = `%.2e'\n") << 25.0);
    std::cout << (format("format .2f .25      = `%.2f'\n") << 0.25);
    std::cout << (format("format .2e .25      = `%.2e'\n") << 0.25);
}
