/**
  *  \file testcall.cc
  *  \brief Test for cpluslib/call.h
  */

#include "cpluslib/call.h"

#include <iostream>

void
foo(Callable2<int, int, int> f)
{
    std::cout << "f(1,2) = " << f(1, 2)
              << "\nf(10,5) = " << f(10,5) << "\n\n";
}

int add(int a, int b) { return a+b; }

int mult(int a, int b) { return a*b; }

struct Adder {
    int x;
    int blub(int a, int b) { return x+a+b; }
    Adder(int xx) : x(xx) { }
};

int
main()
{
    Adder a(9);
    foo(add);
    foo(mult);
    foo(makeCallable(a, &Adder::blub));
}
