#include "cpluslib/bitops.h"

#include "cpluslib/assert.h"
#include <iostream>

int
main()
{
    ASSERT(rol8(1, 1) == 2);
    ASSERT(rol8(1, 2) == 4);
    ASSERT(rol8(1, 4) == 16);
    ASSERT(rol8(1, 8) == 1);

    ASSERT(ror8(1, 1) == 128);
    ASSERT(ror8(1, 2) == 64);
    ASSERT(ror8(1, 4) == 16);
    ASSERT(ror8(1, 8) == 1);

    ASSERT(rol16(1, 1) == 2);
    ASSERT(rol16(1, 2) == 4);
    ASSERT(rol16(1, 4) == 16);
    ASSERT(rol16(1, 15) == 32768U);
    ASSERT(rol16(1, 16) == 1);

    ASSERT(ror16(1, 1) == 32768U);
    ASSERT(ror16(1, 2) == 16384U);
    ASSERT(ror16(1, 4) == 4096U);
    ASSERT(ror16(1, 15) == 2);
    ASSERT(ror16(1, 16) == 1);

    ASSERT(rol32(1, 1) == 2);
    ASSERT(rol32(1, 16) == 65536);
    ASSERT(rol32(0x12345678, 4) == 0x23456781);
    ASSERT(rol32(0xFFFFFFFF, 7) == 0xFFFFFFFF);
    ASSERT(rol32(1, 32) == 1);
    
    ASSERT(ror32(1, 1) == 0x80000000U);
    ASSERT(ror32(1, 16) == 65536);
    ASSERT(ror32(0x12345678, 4) == 0x81234567);
    ASSERT(ror32(0xFFFFFFFF, 7) == 0xFFFFFFFF);
    ASSERT(ror32(1, 32) == 1);

    std::cout << "OK.\n";

    return 0;
}
