/**
  *  \file testarray.cc
  */

#include "cpluslib/array.h"

#include <iostream>
#include <iomanip>

static void
print(array2<const int> a)
{
    for (std::size_t y = 0; y < a.size_y(); ++y) {
        for (std::size_t x = 0; x < a.size_x(); ++x) {
            std::cout << std::setw(5) << a[y][x];
        }
        std::cout << "\n";
    }
    std::cout << "\n";
}

static void
print(array3<int> a)
{
    for (std::size_t z = 0; z < a.size_z(); ++z) {
        std::cout << "z = " << z << ":\n";
        print(a[z]);
    }
}

static int
corr(array1<int> a, array1<int> b)
{
    int sum = 0;
    for (std::size_t i = 0; i < a.size_x(); ++i)
        sum += a[i] * b[i];
    return sum;
}

int
main()
{
    static int a[3][4] = { { 1, 2, 3, 4 }, { 5, 6, 7, 8 }, { 9, 10, 11, 12 } };
    static int b[] = { 55, 66, 77, 88, 99 };
    print(array2<int>(a));
    print(array2<int>(a).transposed_xy());
    print(array1<int>(b).make_2d());
    print(array1<int>(b).with_stride_x(2).make_2d());
    print(array1<int>(b).subrange_x(2,4).make_2d());
    print(array2<int>(a).make_3d());
    print(array1<int>(b).make_3d());
    print(array1<int>(b).make_3d().transposed_xz());
    print(array1<int>(b).make_3d().transposed_yz());
    print(array1<int>(b).make_3d().transposed_xy());
    print(array1<int>(b).make_2d(2));
    print(array1<int>(b).make_2d(1));
    print(array1<int>(b).make_3d(2,2));
    std::cout << corr(array1<int>(a[0]), array1<int>(a[1])) << "\n";
    return 0;
}
