/**
  *  \file fixed_vector_test.cc
  */

#include <iostream>
#include "cpluslib/fixed_vector.h"

struct Counter {
    int n;
    static int c;

    Counter()
        : n(-9999)
        { ++c; }
    Counter(int n)
        : n(n)
        { ++c; }
    Counter(const Counter& o)
        : n(o.n)
        { ++c; }
    ~Counter()
        { --c; /*std::cout << "destroy " << n << "\n";*/ }
};

std::ostream&
operator<<(std::ostream& os, const Counter& c)
{
    return os << c.n;
}

int Counter::c;

template<typename T>
void
print(fixed_vector<T>& v)
{
    std::cout << "{";
    for (unsigned i = 0; i < v.size(); ++i) {
        if (i == 0)
            std::cout << " ";
        else
            std::cout << ", ";
        std::cout << v[i];
    }
    std::cout << " }        " << Counter::c << "\n";
}

int
main()
{
    typedef Counter T;
    static_vector<T,10> is;
    is.push_back(1);
    is.push_back(2);
    is.push_back(3);
    is.push_back(4);
    print(is);
    is.insert(is.begin() + 2, 5);
    print(is);
    try {
        is.insert(is.begin() + 2, static_vector<int,10>::size_type(6), 9);
    }
    catch (...) {
        std::cout << "exception\n";
    }
    print(is);
    is.insert(is.begin() + 2, static_vector<int,10>::size_type(4), 9);
    print(is);
//     is.insert(is.end(), static_vector<int,10>::size_type(4), 9);
    is.erase(is.begin());
    print(is);

    static_vector<T,10>().swap(is);
    print(is);

    std::cout << Counter::c << " objects\n";
    
    return 0;
}
