/**
  *  \file fixed_list_test.cc
  */

#include <iostream>
#include "cpluslib/fixed_list.h"

struct Counter {
    int n;
    static int c;

    Counter()
        : n(-9999)
        { ++c; }
    Counter(int n)
        : n(n)
        { ++c; }
    Counter(const Counter& o)
        : n(o.n)
        { ++c; }
    ~Counter()
        { --c; /*std::cout << "destroy " << n << "\n";*/ }

    bool operator==(const Counter& rhs) const
        { return n == rhs.n; }
    bool operator<(const Counter& rhs) const
        { return n < rhs.n; }
};

std::ostream&
operator<<(std::ostream& os, const Counter& c)
{
    return os << c.n;
}

int Counter::c;

template<typename T>
void
print(fixed_list<T>& v)
{
    std::cout << "{";
    for (typename fixed_list<T>::iterator i = v.begin(); i != v.end(); ++i) {
        if (i == v.begin())
            std::cout << " ";
        else
            std::cout << ", ";
        std::cout << *i;
    }
    std::cout << " }        " << Counter::c << "\n";
}

// template class static_list<Counter,10>;

template class heap_list<Counter>;

int
main()
{
    typedef Counter T;
    heap_list<T> is(20);
    print(is);
    is.push_back(1);
    is.push_back(2);
    is.push_back(3);
    is.push_back(4);
    print(is);
    is.pop_back();
    print(is);
    is.pop_front();
    print(is);
    is.push_back(4);
    is.push_back(5);
    is.push_back(6);
    is.push_back(7);
    const_cast<const heap_list<Counter>&>(is).rend();
    print(is);

    static_list<T,10>::iterator i = is.begin(), j;
    ++i;
    ++i;
    std::cout << *i << " (should be 4)\n";
    i = is.erase(i);
    print(is);
    std::cout << *i << " (should be 5)\n";
    j = is.insert(i,77);
    print(is);
    std::cout << *i << "," << *j << " (should be 5,77)\n";

    is.push_front(333);
    is.insert(is.begin(), 332);
    print(is);
    is.insert(is.end(), 999);
    print(is);

    is.reverse();
    print(is);
    std::cout << *i << "," << *j << " (should be 5,77)\n";
    is.remove(77);
    print(is);

    is.push_back(332);
    is.push_back(332);
    is.push_back(331);
    print(is);
    is.unique();
    print(is);
    is.sort();
    print(is);

    static_list<T,10> ol;
    ol.push_back(1);
    ol.push_back(5);
    ol.push_back(11);
    ol.push_back(333);
    is.merge(ol);
    print(is);
    print(ol);
    
//     is.insert(is.begin() + 2, 5);
//     print(is);
//     try {
//         is.insert(is.begin() + 2, static_vector<int,10>::size_type(6), 9);
//     }
//     catch (...) {
//         std::cout << "exception\n";
//     }
//     print(is);
//     is.insert(is.begin() + 2, static_vector<int,10>::size_type(4), 9); //<---fehler
//     print(is);
// //     is.insert(is.end(), static_vector<int,10>::size_type(4), 9);
//     is.erase(is.begin());
//     print(is);

    static_list<T,20>().swap(is);
//     print(is);

//     std::cout << Counter::c << " objects\n";
//    is.clear();
    print(is);
    std::cout << Counter::c << " objects\n";
    
    return 0;
}
