/**
  *  \file sstringio.cc
  *  \brief simple_string I/O
  *
  *  (c) 2001-2005 Stefan Reuther <Streu@gmx.de>
  *
  *  This program is free software; you can redistribute it and/or
  *  modify it under the terms of file `COPYING' that comes with the
  *  source code.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  */

#include <cstring>
#include <iostream>
#include "cpluslib/sstring.h"
#include "cpluslib/substr.h"

std::ostream&
operator<<(std::ostream& os, const simple_string& str)
{
    // CD2:
    // Begins by constructing a sentry object k as if k were constructed by
    // basic_ostream<charT,traits>::sentry  k(os).   If  bool(k)  is  true,
    // inserts  characters  as  if by calling os.rdbuf()->sputn(str.data(),
    // n), padding as described in stage 3 of _lib.facet.num.put.virtuals_,
    // where  n  is  the  smaller  of os.width() and str.size(); then calls
    // os.width(0).   If  the  call   to   sputn   fails,   calls   os.set-
    // state(ios_base::failbit).
    // ---> /me says "Huh????"

    // Rogue Wave says:
    //   os << str.data()
    // ---> /me says "Clearly bogus."

    // I think I'll use the GNU way:
    return os.write(str.data(), str.length());
}

std::ostream&
operator<<(std::ostream& os, const substring& sub)
{
    return os.write(sub.data(), sub.size());
}

/********************************* Input *********************************/

std::istream&
getline(std::istream& is, simple_string& ss)
{
    return getline(is, ss, '\n');
}

std::istream&
getline(std::istream& is, simple_string& ss, char delim)
{
    // CD2 says: std::istream::sentry k(is);
    // g++ says: `sentry' is not a member of type `istream'
    if (is) {
        char c;
        ss.erase();
        while (is.get(c)) {
            if (c == delim)
                break;
            if (ss.length() >= ss.max_size()) {
                is.setstate(is.failbit);
                break;
            }
            ss.append(&c, 1);
        }
    }
    return is;
}
