/**
  *  \file sigslot.cc
  *  \brief Signal / Slot
  *
  *  (c) 2001-2005 Stefan Reuther <Streu@gmx.de>
  *
  *  This program is free software; you can redistribute it and/or
  *  modify it under the terms of file `COPYING' that comes with the
  *  source code.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  */

#define STREU_CPLUSLIB_KEEP_DEFINE_SIGNAL
#include "cpluslib/sigslot.h"
#include "cpluslib/assert.h"

#define EMPTY
DEFINE_SIGNAL(EMPTY, Signal0, Signal0, EMPTY, EMPTY, EMPTY);

/**************************** SignalConnection ***************************/

/** Constructor. Creates a connected SignalConnection.
    \param handler result of some_signal.add(...), or null */
SignalConnection::SignalConnection(SignalHandler* handler)
    : handler(handler)
{
    if (handler) {
        ASSERT(handler->backlink == 0);
        handler->backlink = &this->handler;
    }
}

/** Re-assign the signal. This will disconnect the previous
    handler. */
void
SignalConnection::operator=(SignalHandler* new_handler)
{
    if (handler == new_handler)
        return;
    delete handler;
    ASSERT(handler == 0);
    handler = new_handler;
    if (handler) {
        ASSERT(handler->backlink == 0);
        handler->backlink = &handler;
    }
}

/** Destructor. Whenever a signal handler dies, it will automatically
    - log off its SignalConnection (pointed-to by #backlink)
    - log off its Signal's handler list (managed with #prev) */
SignalHandler::~SignalHandler()
{
    ASSERT(prev);
    if (next)
        ASSERT(next->prev == &next);

    if (next)
        next->prev = prev;
    *prev = next;

    if (backlink) {
        ASSERT(*backlink == this);
        *backlink = 0;
    }
}
