/**
  *  \file object.cc
  *  \brief Base Class
  *  \author Stefan Reuther
  *
  *  (c) 2001-2005 Stefan Reuther <Streu@gmx.de>
  *
  *  This program is free software; you can redistribute it and/or
  *  modify it under the terms of file `COPYING' that comes with the
  *  source code.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  */
#include "cpluslib/object.h"

/** Virtual destructor. */
Object::~Object()
{ }

#ifdef STREU_CONFIG_OBJECT_HAS_TOSTRING
#  include <typeinfo>
#  include <cstdio>

static string_t
demangle(const char* src)
{
#  ifdef __GNUC__
    /* This version "demangles" unqualified names and leaves qualified
       ones alone. Actual names emitted by gcc:
        eins: 4eins
        eins::zwei: Q24eins4zwei
        drei<int>: t4drei1Zi
        drei<int>::vier: Q2t4drei1Zi4vier
        drei<int>::fuenf<bool>: Q2t4drei1Zit5fuenf1Zb
        drei<eins>::fuenf<eins>: Q2t4drei1Z4einst5fuenf1Z4eins */
    while (*src >= '0' && *src <= '9')
        ++src;
#  endif
    
    return string_t(src);
}

/** Get string representation of object. Override this if you have a
    better way. By default, this function returns the RTTI name of the
    object (demangled for some gcc versions), and its pointer. */
string_t
Object::toString()
{
    char addr[100];
    std::sprintf(addr, "[%p]", (void*) this);

    return demangle(typeid(*this).name()) + addr;
}
#endif
