/**
  *  \file stringcv.h
  *  \brief String Conversions
  *
  *  This module contains functions to convert between simple_string,
  *  std::string, and string_t. They are separate so that we don't
  *  pull in \<string> when we don't need it. For gcc, this generates
  *  quite a bit of extra code.
  */
#ifndef STREU_CPLUSLIB_STRINGCV_H_INCLUDED
#define STREU_CPLUSLIB_STRINGCV_H_INCLUDED

#include "cpluslib/config.h"
#include "cpluslib/string.h"

#ifdef STREU_CONFIG_USE_STD_STRING
#include "cpluslib/sstring.h"
/* string_t is std::string */
static inline const std::string& toStandardString(const string_t& s) { return s; }
static inline simple_string toSimpleString(const string_t& s) { return simple_string(s.data(), s.length()); }
static inline const string_t& toStringType(const std::string& s) { return s; }
static inline string_t toStringType(const simple_string& s) { return string_t(s.data(), s.length()); }
#else
#include <string>
/* string_t is simple_string (default) */
static inline std::string toStandardString(const string_t& s) { return std::string(s.data(), s.length()); }
static inline const simple_string& toSimpleString(const string_t& s) { return s; }
static inline const string_t& toStringType(const simple_string& s) { return s; }
static inline string_t toStringType(const std::string& s) { return string_t(s.data(), s.length()); }
#endif

#endif
