/**
  *  \file cpluslib/misc.h
  *  \brief Miscellaneous stuff
  *  \author Stefan Reuther
  */
#ifndef STREU_CPLUSLIB_MISC_H_INCLUDED
#define STREU_CPLUSLIB_MISC_H_INCLUDED

#include <cstring>

/** Number of elements in an array. */
#define countof(x) (sizeof(x)/sizeof(x[0]))

/** Zero-fill a POD. This is guaranteed to set all char and unsigned
    integer members to "zero". The C++ standard does not guarantee
    that "0" pointers or floats have a representation of
    all-bits-zero, though. */
template<class T>
inline void
zeroFill(T& t) {
    std::memset(&t, 0, sizeof(t));
}

#endif
