/**
  *  \file holder.h
  *  \brief Object Lifetime Control
  *  \author Stefan Reuther
  */
#ifndef STREU_CPLUSLIB_HOLDER_H_INCLUDED
#define STREU_CPLUSLIB_HOLDER_H_INCLUDED

#include <vector>
#include "cpluslib/config.h"
#include "cpluslib/object.h"

/** Object Lifetime Control. This class provides a simple object store
    in which you can place heap-allocated objects. When the
    ObjectHolder dies, it deletes all the contained objects. Only
    descendants of #Object are supported. */
class ObjectHolder : public Object {
    typedef std::vector<Object*> list_t;
    list_t list;
    void doAdd(Object* p);
 public:
    ObjectHolder();
    ~ObjectHolder();

    /** Add object. This function returns *p of the correct type, so
        you can bind it to a reference, as in
        <tt>MyObj& o = h.add(new MyObj());</tt>
        If the operation fails, deletes p and rethrows the exception. */
    template<class T>
    T& add(T* p)
        { doAdd(p); return *p; }

    void addNoCatch(Object* p);

    void moveTo(ObjectHolder& other);
    void clear();
};

#endif
