/**
  *  \file cpluslib/enum.h
  *  \brief Enumeration
  *  \author Stefan Reuther
  */

#ifndef STREU_CPLUSLIB_ENUM_H_INCLUDED
#define STREU_CPLUSLIB_ENUM_H_INCLUDED

#include "cpluslib/object.h"

/** Enumeration. A generalized form of an input iterator, differing
    from the STL iterator mainly in the fact that this one explicitly
    provides late binding and does not require the iterator to be
    copyable. */
template<class T>
class Enumeration : public Object {
 public:
    /** Virtual destructor. */
    virtual ~Enumeration()
        { }

    /** Check for Elements.
        \return true iff there are more elements in this enumeration */
    virtual bool hasMoreElements() = 0;

    /** Get next element.
        \return the element
        \pre hasMoreElements() == true */
    virtual T getNextElement() = 0;
};

#endif
