/**
  *  \file cstring.h
  *  \brief Operations on Character Arrays
  *  \author Stefan Reuther
  */
#ifndef STREU_CPLUSLIB_CSTRING_H_INCLUDED
#define STREU_CPLUSLIB_CSTRING_H_INCLUDED

#include <cstddef>

/** Container for character array operations. */
struct cstring_util {
    /** Type of string indexes. */
    typedef std::size_t size_type, sizeT;
    /** Type of string characters. */
    typedef const char  value_type, charT;
    /** String index meaning "not found". */
    static const sizeT npos = sizeT(-1);

    static int   compare(charT* astr, sizeT alen,
                         charT* bstr, sizeT blen);
    static sizeT find(charT* haystack, sizeT hlen, sizeT hpos,
                      charT* needle,   sizeT nlen);
    static sizeT find(charT* haystack, sizeT hlen, sizeT hpos, char needle);

    static sizeT rfind(charT* haystack, sizeT hlen, sizeT hpos,
                       charT* needle,   sizeT nlen);
    static sizeT rfind(charT* haystack, sizeT hlen, sizeT hpos, char needle);

    static sizeT find_first_of(charT* haystack, sizeT hlen, sizeT hpos,
                               charT* needle,   sizeT nlen);

    static sizeT find_last_of(charT* haystack, sizeT hlen, sizeT hpos,
                              charT* needle,   sizeT nlen);

    static sizeT find_last_not_of(charT* haystack, sizeT hlen, sizeT hpos,
                                  charT* needle,   sizeT nlen);

    static sizeT find_first_not_of(charT* haystack, sizeT hlen, sizeT hpos,
                                   charT* needle,   sizeT nlen);
};

#endif
