/**
  *  \file assert.cc
  *  \brief Static Checks
  *  \author Stefan Reuther
  *
  *  This file contains the assertionFailed() function. Do not add
  *  more functions to allow users to override the function by
  *  providing an own version in their own code. In this case, the
  *  linker will just ignore this module.
  *
  *  (c) 2001-2005 Stefan Reuther <Streu@gmx.de>
  *
  *  This program is free software; you can redistribute it and/or
  *  modify it under the terms of file `COPYING' that comes with the
  *  source code.
  *
  *  This program is distributed in the hope that it will be useful,
  *  but WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  */
#include "cpluslib/assert.h"

#include <iostream>
#include <csignal>

/** Assertion Failure. Show message on stdout and raise SIGSEGV.
    Raising a signal can be caught better in the debugger/tracer. This
    is the default implementation, you can override this function and
    provide your own. */
int
assertionFailed(const char* what, const char* file, int line)
{
    std::cerr << file << ":" << line << ": INTERNAL ERROR: "
              << what << std::endl << std::flush;
    std::raise(SIGSEGV);
    return 0;
}
