/**
  *  \file test/game/vcr/flak/testapplettest.cpp
  *  \brief Test for game::vcr::flak::TestApplet
  */

#include "game/vcr/flak/testapplet.hpp"

#include "afl/io/internalfilesystem.hpp"
#include "afl/io/internalstream.hpp"
#include "afl/sys/internalenvironment.hpp"
#include "afl/test/testrunner.hpp"
#include "game/test/files.hpp"
#include "util/io.hpp"

using afl::io::FileSystem;
using afl::io::InternalFileSystem;
using afl::io::InternalStream;
using afl::sys::Environment;
using afl::sys::InternalEnvironment;

namespace {
    const uint8_t FILE_CONTENT[] = {
        // Header
        0x46, 0x4c, 0x41, 0x4b, 0x56, 0x43, 0x52, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x01, 0x00,
        0x30, 0x39, 0x2d, 0x32, 0x32, 0x2d, 0x32, 0x30, 0x30, 0x36, 0x32, 0x33, 0x3a, 0x30, 0x30, 0x3a,
        0x35, 0x31, 0x00, 0x00, 0x00, 0x00,

        // Battle from setuptest.cpp
        0xb8, 0x02, 0x00, 0x00, 0x23, 0x0a, 0xde, 0x09, 0xc9, 0x7a, 0x3d, 0x6d, 0x60, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x88, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x03, 0x00, 0x64, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xe0, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x65, 0x42, 0x00, 0x00, 0x29, 0x01, 0x00, 0x00, 0x09, 0x00, 0x04, 0x00, 0x02, 0x00, 0x64, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xe3, 0x55, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
        0x04, 0x00, 0x06, 0x00, 0x02, 0x00, 0x64, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xa0, 0x92, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x42, 0x61, 0x72, 0x69, 0x75,
        0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x6e, 0x00,
        0x2b, 0x00, 0x09, 0x00, 0x51, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0c, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x64, 0x00, 0x01, 0x00, 0x83, 0x00, 0x00, 0x00,
        0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x47, 0x69, 0x62, 0x61, 0x72, 0x69, 0x61,
        0x6e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x0b, 0x04, 0xc9, 0x00,
        0x09, 0x00, 0x53, 0x00, 0x01, 0x00, 0x0a, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x36, 0x00, 0x6f, 0x01, 0x64, 0x00, 0x10, 0x00, 0xf5, 0x01, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x4e, 0x69, 0x74, 0x72, 0x6f, 0x67, 0x65, 0x6e, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x36, 0x01, 0x09, 0x00,
        0x53, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
        0x36, 0x00, 0xe2, 0x01, 0x64, 0x00, 0x10, 0x00, 0x7c, 0x02, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x54, 0x68, 0x65, 0x74, 0x61, 0x20, 0x56, 0x49, 0x49, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0xba, 0x01, 0x09, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x07, 0x00, 0x0a, 0x00, 0x06, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x26, 0x00,
        0xe6, 0x00, 0x64, 0x00, 0x1a, 0x00, 0xca, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x01, 0x00, 0x00, 0x00,
        0x52, 0x4b, 0x20, 0x56, 0x61, 0x6e, 0x64, 0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x06, 0x08, 0xb4, 0x02, 0x09, 0x00, 0x4f, 0x00, 0x01, 0x00,
        0x07, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x69, 0x00, 0x21, 0x03,
        0x64, 0x00, 0x20, 0x00, 0xe7, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x52, 0x4b,
        0x20, 0x53, 0x74, 0x72, 0x6f, 0x6e, 0x74, 0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x06, 0x08, 0xce, 0x03, 0x09, 0x00, 0x4f, 0x00, 0x01, 0x00, 0x07, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x5f, 0x00, 0x53, 0x03, 0x64, 0x00,
        0x20, 0x00, 0x19, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x75, 0x72, 0x74,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x13, 0x03, 0x96, 0x01, 0x04, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x09, 0x00,
        0x0d, 0x00, 0x59, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x02, 0x64, 0x00, 0x01, 0x00,
        0xa2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x47, 0x72, 0x61, 0x75, 0x74, 0x76,
        0x6f, 0x72, 0x6e, 0x69, 0x78, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x13, 0x03, 0xd1, 0x02, 0x04, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x09, 0x00, 0x0d, 0x00,
        0x64, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x99, 0x02, 0x64, 0x00, 0x01, 0x00, 0xa2, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x06, 0x00, 0x32, 0x00, 0x07, 0x00, 0x2a, 0x00,
        0x06, 0x00, 0x1f, 0x00, 0x07, 0x00, 0x1c, 0x00, 0x06, 0x00, 0x2f, 0x00, 0x07, 0x00, 0x28, 0x00,
        0x00, 0x00, 0x33, 0x00, 0x01, 0x00, 0x32, 0x00, 0x02, 0x00, 0x3a, 0x00, 0x03, 0x00, 0x2a, 0x00,
        0x04, 0x00, 0x2a, 0x00, 0x05, 0x00, 0x2c, 0x00
    };

    void prepareFileSystem(InternalFileSystem& fs)
    {
        fs.createDirectory("/root");
        fs.openFile("/root/race.nm", FileSystem::Create)->fullWrite(game::test::getDefaultRaceNames());
        fs.openFile("/root/torpspec.dat", FileSystem::Create)->fullWrite(game::test::getDefaultTorpedoes());
        fs.openFile("/root/engspec.dat",  FileSystem::Create)->fullWrite(game::test::getDefaultEngines());
        fs.openFile("/root/hullspec.dat", FileSystem::Create)->fullWrite(game::test::getDefaultHulls());
        fs.openFile("/root/truehull.dat", FileSystem::Create)->fullWrite(game::test::getDefaultHullAssignments());

        fs.createDirectory("/game");
        fs.openFile("/game/flak.dat", FileSystem::Create)->fullWrite(FILE_CONTENT);
        fs.openFile("/game/beamspec.dat", FileSystem::Create)->fullWrite(game::test::getDefaultBeams());  // in game directory instead of default, to exercise spec file lookup
    }
}

AFL_TEST("game.vcr.flak.TestApplet", a)
{
    InternalEnvironment env;
    InternalFileSystem fs;

    afl::base::Ptr<InternalStream> out = new InternalStream();
    env.setChannelStream(Environment::Output, out);
    env.setChannelStream(Environment::Error, out);
    env.setInstallationDirectoryName("/install");
    prepareFileSystem(fs);

    afl::data::StringList_t args;
    args.push_back("app");
    args.push_back("/game/flak.dat"); // file name parameter
    args.push_back("/game");          // directory parameter
    args.push_back("/root");          // root directory parameter
    env.setCommandLine(args);

    util::Applet::Runner("", env, fs)
        .addNew("app", "", new game::vcr::flak::TestApplet())
        .run();

    String_t output = util::normalizeLinefeeds(out->getContent());
    a.checkEqual("", output,
                 "Battle 1...\n"
                 "  Time according to header:     352\n"
                 "  Real time taken:              273\n"
                 "    Unit   0 (ship   #43 ): damage   0, crew  110, shield 100, torps   9, fighters   0\n"
                 "    Unit   1 (ship   #201): damage   0, crew 1035, shield 100, torps   0, fighters  40\n"
                 "    Unit   2 (ship   #310): damage   0, crew 1035, shield 100, torps   0, fighters  41\n"
                 "    Unit   3 (planet #442): damage   0, crew    0, shield 100, torps   0, fighters  35\n"
                 "    Unit   4 (ship   #692): damage   0, crew 2054, shield 100, torps   0, fighters 105\n"
                 "    Unit   5 (ship   #974): damage  67, crew 1875, shield   0, torps   0, fighters  95\n"
                 "    Unit   6 (ship   #406): damage 113, crew  773, shield   0, torps  76, fighters   0\n"
                 "    Unit   7 (ship   #721): damage 104, crew  747, shield   0, torps  95, fighters   0\n");
}

AFL_TEST("game.vcr.flak.TestApplet:help", a)
{
    InternalEnvironment env;
    InternalFileSystem fs;

    afl::base::Ptr<InternalStream> out = new InternalStream();
    env.setChannelStream(Environment::Output, out);
    env.setChannelStream(Environment::Error, out);
    env.setInstallationDirectoryName("/install");
    prepareFileSystem(fs);

    afl::data::StringList_t args;
    args.push_back("app");
    env.setCommandLine(args);

    util::Applet::Runner("", env, fs)
        .addNew("app", "", new game::vcr::flak::TestApplet())
        .run();

    String_t output = util::normalizeLinefeeds(out->getContent());
    a.checkContains("", output, "Usage:");
}
