/**
  *  \file test/game/vcr/flak/databasetest.cpp
  *  \brief Test for game::vcr::flak::Database
  */

#include "game/vcr/flak/database.hpp"

#include "afl/charset/codepage.hpp"
#include "afl/charset/codepagecharset.hpp"
#include "afl/io/constmemorystream.hpp"
#include "afl/io/internalstream.hpp"
#include "afl/string/nulltranslator.hpp"
#include "afl/test/testrunner.hpp"
#include "game/config/hostconfiguration.hpp"

namespace {
    // FLAK0 flak.hst
    const uint8_t FILE_CONTENT[] = {
        0x46, 0x4c, 0x41, 0x4b, 0x56, 0x43, 0x52, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x46, 0x00, 0x03, 0x00,
        0x30, 0x39, 0x2d, 0x32, 0x32, 0x2d, 0x32, 0x30, 0x30, 0x36, 0x32, 0x33, 0x3a, 0x30, 0x30, 0x3a,
        0x35, 0x31, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x14, 0x00, 0x00, 0x12, 0x07, 0xc4, 0x07, 0xfb, 0x98,
        0xc4, 0x36, 0xd4, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x18, 0x00,
        0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0xe0, 0x00,
        0x00, 0x00, 0xe9, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x58, 0x11, 0x00, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x0f, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0xa0, 0x92,
        0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x64, 0x00, 0x1f, 0x00,
        0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1d, 0x7f, 0xff, 0xff, 0xc0, 0xfd, 0xff, 0xff, 0x0a, 0x00,
        0x19, 0x00, 0x0b, 0x00, 0x64, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0xa7, 0x6b,
        0xff, 0xff, 0xd2, 0xfa, 0xff, 0xff, 0x0a, 0x00, 0x24, 0x00, 0x01, 0x00, 0x64, 0x00, 0x5d, 0x00,
        0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x43, 0x58, 0xff, 0xff, 0x36, 0xf7, 0xff, 0xff, 0x07, 0x00,
        0x25, 0x00, 0x0f, 0x00, 0x64, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0xe0, 0x2e,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x34, 0x00, 0x0f, 0x00, 0x64, 0x00, 0xa0, 0x00,
        0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x65, 0x42, 0x00, 0x00, 0x29, 0x01, 0x00, 0x00, 0x07, 0x00,
        0x43, 0x00, 0x01, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0xe3, 0x55,
        0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x4e, 0x65, 0x73, 0x73, 0x65, 0x6c, 0x68, 0x61, 0x69, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x1b, 0x00,
        0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x87, 0x00, 0xf8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xf6, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x51, 0x75, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x59, 0x00, 0x0a, 0x00,
        0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x86, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x41, 0x61, 0x6c, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x91, 0x00, 0x0a, 0x00, 0x5e, 0x00,
        0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x86, 0x00,
        0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x48, 0x61, 0x69, 0x6c, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xda, 0x01, 0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x78, 0x00, 0xf8, 0x02,
        0x64, 0x00, 0x1a, 0x00, 0xf6, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x42, 0x6c,
        0x61, 0x75, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x2e, 0x02, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x0e, 0x03, 0x64, 0x00,
        0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x52, 0x65, 0x67, 0x65,
        0x6e, 0x62, 0x6f, 0x67, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x08, 0x07, 0x54, 0x02, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00,
        0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x54, 0x69, 0x65, 0x66, 0x73, 0x65,
        0x65, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x08, 0x07, 0x93, 0x02, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x54, 0x6f, 0x6e, 0x6e, 0x65, 0x6e, 0x68, 0x61,
        0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07,
        0xb6, 0x02, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x65, 0x74, 0x74, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xf3, 0x02,
        0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x78, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x4b, 0x6f, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xf4, 0x02, 0x0a, 0x00,
        0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x8c, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x53, 0x61, 0x6d, 0x6d, 0x65, 0x6c, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xfd, 0x02, 0x0a, 0x00, 0x5e, 0x00,
        0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00,
        0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x4d, 0x61, 0x61, 0x74, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x01, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00,
        0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x0e, 0x03,
        0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x46, 0x6c,
        0x75, 0x73, 0x73, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x1c, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x78, 0x00, 0x0e, 0x03, 0x64, 0x00,
        0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4a, 0x6f, 0x6a, 0x6f,
        0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x08, 0x07, 0x38, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00,
        0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x6e, 0x69, 0x74, 0x74, 0x65,
        0x72, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x08, 0x07, 0x3e, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x46, 0x6c, 0x65, 0x63, 0x6b, 0x65, 0x6e, 0x68,
        0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07,
        0x3f, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x52, 0x6f, 0x73, 0x73, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x40, 0x03,
        0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x8c, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x4c, 0x61, 0x76, 0x61, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x43, 0x03, 0x0a, 0x00,
        0x5e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x87, 0x00, 0xf8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xf6, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x4d, 0x6f, 0x6f, 0x72, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x47, 0x03, 0x0a, 0x00, 0x5e, 0x00,
        0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00,
        0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x54, 0x75, 0x6c, 0x70, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x6d, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00,
        0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x03, 0x03,
        0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x54, 0x61,
        0x66, 0x65, 0x6c, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x70, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x03, 0x03, 0x64, 0x00,
        0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4f, 0x73, 0x74, 0x65,
        0x72, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x08, 0x07, 0x85, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0xf8, 0x02, 0x64, 0x00, 0x1a, 0x00,
        0xf6, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x54, 0x61, 0x72, 0x61, 0x6e, 0x74,
        0x65, 0x6c, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x08, 0x07, 0x8c, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x03, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x01, 0x04,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x69, 0x6c, 0x6c, 0x65, 0x72, 0x68, 0x61,
        0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07,
        0x9b, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0xf8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xf6, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x53, 0x75, 0x6d, 0x6f, 0x72, 0x69, 0x68, 0x61, 0x69, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xe2, 0x03,
        0x0a, 0x00, 0x5e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x87, 0x00, 0xf8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xf6, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x5a, 0x61, 0x68, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x7c, 0x00, 0x0a, 0x00,
        0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x87, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x57, 0x6f, 0x6c, 0x66, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xa8, 0x00, 0x0a, 0x00, 0x5e, 0x00,
        0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x87, 0x00,
        0xd8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xd6, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x5a, 0x69, 0x74, 0x72, 0x6f, 0x6e, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xca, 0x00, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00,
        0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x87, 0x00, 0x0e, 0x03,
        0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x54, 0x69,
        0x67, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xe7, 0x00, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8a, 0x00, 0xd8, 0x02, 0x64, 0x00,
        0x1a, 0x00, 0xd6, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x50, 0x75, 0x6d, 0x61,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x08, 0x07, 0x0f, 0x01, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00,
        0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x47, 0x65, 0x72, 0x70, 0x61, 0x72,
        0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x08, 0x07, 0x74, 0x01, 0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x87, 0x00, 0xd8, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xd6, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x65, 0x6f, 0x70, 0x61, 0x72, 0x64, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07,
        0xaf, 0x01, 0x0a, 0x00, 0x5e, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0e, 0x00, 0x8c, 0x00, 0xde, 0x02, 0x64, 0x00, 0x1c, 0x00, 0xd5, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x54, 0x69, 0x67, 0x65, 0x72, 0x68, 0x61, 0x69, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0xef, 0x06, 0xe9, 0x01,
        0x0a, 0x00, 0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0d, 0x00, 0x8b, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x53, 0x74, 0x69, 0x65, 0x66, 0x65, 0x6c, 0x68, 0x61, 0x69, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xb0, 0x02, 0x0a, 0x00,
        0x5e, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x87, 0x00, 0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x4d, 0x69, 0x6c, 0x63, 0x68, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0xec, 0x02, 0x0a, 0x00, 0x5e, 0x00,
        0x02, 0x00, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x8c, 0x00,
        0x0e, 0x03, 0x64, 0x00, 0x1a, 0x00, 0x0c, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x41, 0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x65, 0x6e, 0x68, 0x61, 0x69, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x08, 0x07, 0x9a, 0x03, 0x0a, 0x00, 0x5e, 0x00, 0x01, 0x00,
        0x0f, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x82, 0x00, 0x03, 0x03,
        0x64, 0x00, 0x1a, 0x00, 0x01, 0x04, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x49, 0x67,
        0x65, 0x6c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x4e, 0x01, 0x60, 0x02, 0x0a, 0x00, 0x07, 0x00, 0x01, 0x00, 0x06, 0x00,
        0x0a, 0x00, 0x03, 0x00, 0x38, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x01, 0x64, 0x00,
        0x01, 0x00, 0x87, 0x01, 0x00, 0x00, 0xc2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x44, 0x49, 0x41, 0x4d,
        0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20,
        0x00, 0x00, 0x0b, 0x04, 0x78, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0a, 0x00,
        0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x02, 0x64, 0x00, 0x01, 0x00,
        0xac, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x6d,
        0x61, 0x63, 0x68, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x0b, 0x04, 0x06, 0x01, 0x07, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00,
        0x85, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x02, 0x64, 0x00, 0x01, 0x00, 0xac, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20,
        0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04,
        0xb2, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c,
        0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x8a, 0x03,
        0x07, 0x00, 0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d,
        0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x56, 0x03, 0x07, 0x00,
        0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00, 0xc2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x53, 0x49, 0x4c, 0x49, 0x43, 0x4f, 0x4e, 0x20, 0x41, 0x56, 0x41, 0x54, 0x41, 0x52,
        0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x16, 0x00, 0x1d, 0x02, 0xed, 0x02, 0x07, 0x00, 0x43, 0x00,
        0x02, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x96, 0x00,
        0x46, 0x02, 0x4e, 0x00, 0x1a, 0x00, 0x08, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x53, 0x49, 0x4c, 0x49, 0x43, 0x4f, 0x4e, 0x20, 0x41, 0x56, 0x41, 0x54, 0x41, 0x52, 0x20, 0x43,
        0x4c, 0x41, 0x53, 0x53, 0x00, 0x00, 0x1d, 0x02, 0xe7, 0x02, 0x07, 0x00, 0x43, 0x00, 0x02, 0x00,
        0x09, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x96, 0x00, 0x46, 0x02,
        0x64, 0x00, 0x1a, 0x00, 0x08, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x53, 0x49,
        0x4c, 0x49, 0x43, 0x4f, 0x4e, 0x20, 0x41, 0x56, 0x41, 0x54, 0x41, 0x52, 0x20, 0x43, 0x4c, 0x41,
        0x53, 0x53, 0x00, 0x00, 0x1d, 0x02, 0xb2, 0x02, 0x07, 0x00, 0x43, 0x00, 0x02, 0x00, 0x09, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x96, 0x00, 0x46, 0x02, 0x64, 0x00,
        0x1a, 0x00, 0x08, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x53, 0x49, 0x4c, 0x49,
        0x43, 0x4f, 0x4e, 0x20, 0x41, 0x56, 0x41, 0x54, 0x41, 0x52, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53,
        0x00, 0x00, 0x1d, 0x02, 0xad, 0x02, 0x07, 0x00, 0x43, 0x00, 0x02, 0x00, 0x09, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x96, 0x00, 0x46, 0x02, 0x64, 0x00, 0x1a, 0x00,
        0x08, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e,
        0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00,
        0x0b, 0x04, 0x9b, 0x02, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00,
        0x85, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00, 0xc2, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20,
        0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04,
        0x8b, 0x02, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00, 0xc2, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c,
        0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x5d, 0x02,
        0x07, 0x00, 0x3f, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xe7, 0x02, 0x64, 0x00, 0x01, 0x00, 0xcd, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d,
        0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x20, 0x02, 0x07, 0x00,
        0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x61, 0x6c, 0x73, 0x20, 0x74, 0x6f, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x06, 0x00, 0x0b, 0x04, 0x50, 0x01, 0x07, 0x00, 0x3f, 0x00,
        0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x85, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xdc, 0x02, 0x5e, 0x00, 0x01, 0x00, 0xc2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x41, 0x6c, 0x63, 0x6d, 0x65, 0x6e, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x16, 0x00, 0x1d, 0x02, 0xdb, 0x00, 0x07, 0x00, 0x43, 0x00, 0x03, 0x00,
        0x09, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x96, 0x00, 0x51, 0x02,
        0x4e, 0x00, 0x1c, 0x00, 0x09, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49,
        0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53,
        0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x26, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0c, 0x00,
        0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x02, 0x64, 0x00,
        0x01, 0x00, 0xac, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x61, 0x70, 0x69,
        0x74, 0x68, 0x61, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x0b, 0x04, 0x3f, 0x01, 0x07, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x0a, 0x00,
        0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x02, 0x64, 0x00, 0x01, 0x00,
        0xac, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e,
        0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00,
        0x0b, 0x04, 0xa2, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00,
        0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20,
        0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04,
        0x84, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c,
        0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x08, 0x00, 0x0b, 0x04, 0x76, 0x03,
        0x07, 0x00, 0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xd1, 0x02, 0x5c, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d,
        0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x55, 0x03, 0x07, 0x00,
        0x3f, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xd1, 0x02, 0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x53, 0x49, 0x4c, 0x49, 0x43, 0x4f, 0x4e, 0x20, 0x41, 0x56, 0x41, 0x54, 0x41, 0x52,
        0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x00, 0x00, 0x1d, 0x02, 0x4c, 0x03, 0x07, 0x00, 0x43, 0x00,
        0x01, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x7c, 0x00,
        0x3b, 0x02, 0x64, 0x00, 0x1a, 0x00, 0xfd, 0x02, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c,
        0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x4b, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x01, 0x00,
        0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x02,
        0x64, 0x00, 0x01, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49,
        0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53,
        0x53, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x29, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00,
        0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00,
        0x01, 0x00, 0xc2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d,
        0x4f, 0x4e, 0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20,
        0x00, 0x00, 0x0b, 0x04, 0x16, 0x03, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00,
        0x0b, 0x00, 0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00,
        0xc2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e,
        0x44, 0x20, 0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00,
        0x0b, 0x04, 0xf2, 0x02, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00,
        0x96, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00, 0xc2, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x44, 0x49, 0x41, 0x4d, 0x4f, 0x4e, 0x44, 0x20,
        0x46, 0x4c, 0x41, 0x4d, 0x45, 0x20, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x20, 0x00, 0x00, 0x0b, 0x04,
        0xef, 0x02, 0x07, 0x00, 0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x96, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x64, 0x00, 0x01, 0x00, 0xc2, 0x03, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x50, 0x65, 0x67, 0x61, 0x73, 0x75, 0x73, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x1d, 0x02, 0xc0, 0x01,
        0x07, 0x00, 0x43, 0x00, 0x03, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0e, 0x00, 0x78, 0x00, 0x51, 0x02, 0x64, 0x00, 0x1c, 0x00, 0x1b, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x50, 0x61, 0x6c, 0x6c, 0x61, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x16, 0x00, 0x0b, 0x04, 0x51, 0x00, 0x07, 0x00,
        0x3f, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x8c, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xdc, 0x02, 0x4e, 0x00, 0x01, 0x00, 0xc2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x4d, 0x65, 0x6c, 0x70, 0x6f, 0x6d, 0x65, 0x6e, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x1d, 0x02, 0x7f, 0x00, 0x07, 0x00, 0x43, 0x00,
        0x02, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x96, 0x00,
        0x46, 0x02, 0x64, 0x00, 0x1a, 0x00, 0x08, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff,
        0x4f, 0x6d, 0x65, 0x67, 0x61, 0x20, 0x49, 0x56, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x45, 0x01, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x06, 0x00, 0x06, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0d, 0x00, 0x09, 0x00, 0xc5, 0x00,
        0x64, 0x00, 0x1a, 0x00, 0x6f, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x01, 0x00, 0x0a, 0x00, 0x25, 0x00,
        0x30, 0x00, 0x26, 0x00, 0x30, 0x00, 0x27, 0x00, 0x32, 0x00, 0x28, 0x00, 0x3a, 0x00, 0x29, 0x00,
        0x39, 0x00, 0x2a, 0x00, 0x36, 0x00, 0x2b, 0x00, 0x28, 0x00, 0x2c, 0x00, 0x35, 0x00, 0x2d, 0x00,
        0x28, 0x00, 0x2e, 0x00, 0x2a, 0x00, 0x2f, 0x00, 0x2d, 0x00, 0x30, 0x00, 0x30, 0x00, 0x31, 0x00,
        0x2f, 0x00, 0x32, 0x00, 0x29, 0x00, 0x33, 0x00, 0x2b, 0x00, 0x34, 0x00, 0x30, 0x00, 0x35, 0x00,
        0x2d, 0x00, 0x36, 0x00, 0x35, 0x00, 0x37, 0x00, 0x30, 0x00, 0x38, 0x00, 0x34, 0x00, 0x39, 0x00,
        0x37, 0x00, 0x3a, 0x00, 0x37, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3c, 0x00, 0x37, 0x00, 0x3d, 0x00,
        0x35, 0x00, 0x3e, 0x00, 0x3b, 0x00, 0x3f, 0x00, 0x2f, 0x00, 0x40, 0x00, 0x30, 0x00, 0x41, 0x00,
        0x31, 0x00, 0x42, 0x00, 0x34, 0x00, 0x43, 0x00, 0x2b, 0x00, 0x25, 0x00, 0x35, 0x00, 0x26, 0x00,
        0x32, 0x00, 0x27, 0x00, 0x38, 0x00, 0x28, 0x00, 0x32, 0x00, 0x29, 0x00, 0x34, 0x00, 0x2a, 0x00,
        0x38, 0x00, 0x2b, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x37, 0x00, 0x2d, 0x00, 0x3b, 0x00, 0x2e, 0x00,
        0x2b, 0x00, 0x2f, 0x00, 0x2b, 0x00, 0x30, 0x00, 0x2c, 0x00, 0x31, 0x00, 0x2b, 0x00, 0x32, 0x00,
        0x2b, 0x00, 0x33, 0x00, 0x2d, 0x00, 0x34, 0x00, 0x35, 0x00, 0x35, 0x00, 0x32, 0x00, 0x36, 0x00,
        0x29, 0x00, 0x37, 0x00, 0x3a, 0x00, 0x38, 0x00, 0x38, 0x00, 0x39, 0x00, 0x3a, 0x00, 0x3a, 0x00,
        0x3b, 0x00, 0x3b, 0x00, 0x39, 0x00, 0x3c, 0x00, 0x2b, 0x00, 0x3d, 0x00, 0x2b, 0x00, 0x3e, 0x00,
        0x33, 0x00, 0x3f, 0x00, 0x39, 0x00, 0x40, 0x00, 0x37, 0x00, 0x41, 0x00, 0x37, 0x00, 0x42, 0x00,
        0x32, 0x00, 0x43, 0x00, 0x2b, 0x00, 0x25, 0x00, 0x34, 0x00, 0x26, 0x00, 0x39, 0x00, 0x27, 0x00,
        0x28, 0x00, 0x28, 0x00, 0x3a, 0x00, 0x29, 0x00, 0x30, 0x00, 0x2a, 0x00, 0x32, 0x00, 0x2b, 0x00,
        0x2c, 0x00, 0x2c, 0x00, 0x3b, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x31, 0x00, 0x2f, 0x00,
        0x38, 0x00, 0x30, 0x00, 0x3a, 0x00, 0x31, 0x00, 0x29, 0x00, 0x32, 0x00, 0x2a, 0x00, 0x33, 0x00,
        0x30, 0x00, 0x34, 0x00, 0x2b, 0x00, 0x35, 0x00, 0x2a, 0x00, 0x36, 0x00, 0x38, 0x00, 0x37, 0x00,
        0x2e, 0x00, 0x38, 0x00, 0x38, 0x00, 0x39, 0x00, 0x2c, 0x00, 0x3a, 0x00, 0x31, 0x00, 0x3b, 0x00,
        0x33, 0x00, 0x3c, 0x00, 0x36, 0x00, 0x3d, 0x00, 0x38, 0x00, 0x3e, 0x00, 0x37, 0x00, 0x3f, 0x00,
        0x3a, 0x00, 0x40, 0x00, 0x30, 0x00, 0x41, 0x00, 0x2a, 0x00, 0x42, 0x00, 0x2e, 0x00, 0x43, 0x00,
        0x3b, 0x00, 0x25, 0x00, 0x1b, 0x00, 0x26, 0x00, 0x14, 0x00, 0x27, 0x00, 0x19, 0x00, 0x28, 0x00,
        0x27, 0x00, 0x29, 0x00, 0x21, 0x00, 0x2a, 0x00, 0x18, 0x00, 0x2b, 0x00, 0x20, 0x00, 0x2c, 0x00,
        0x14, 0x00, 0x2d, 0x00, 0x16, 0x00, 0x2e, 0x00, 0x16, 0x00, 0x2f, 0x00, 0x17, 0x00, 0x30, 0x00,
        0x25, 0x00, 0x31, 0x00, 0x1b, 0x00, 0x32, 0x00, 0x26, 0x00, 0x33, 0x00, 0x19, 0x00, 0x34, 0x00,
        0x16, 0x00, 0x35, 0x00, 0x23, 0x00, 0x36, 0x00, 0x1d, 0x00, 0x37, 0x00, 0x19, 0x00, 0x38, 0x00,
        0x14, 0x00, 0x39, 0x00, 0x1c, 0x00, 0x3a, 0x00, 0x1e, 0x00, 0x3b, 0x00, 0x16, 0x00, 0x3c, 0x00,
        0x20, 0x00, 0x3d, 0x00, 0x18, 0x00, 0x3e, 0x00, 0x1c, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x40, 0x00,
        0x22, 0x00, 0x41, 0x00, 0x22, 0x00, 0x42, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x29, 0x00, 0x01, 0x00,
        0x39, 0x00, 0x02, 0x00, 0x2e, 0x00, 0x03, 0x00, 0x2f, 0x00, 0x04, 0x00, 0x39, 0x00, 0x05, 0x00,
        0x2f, 0x00, 0x06, 0x00, 0x2a, 0x00, 0x07, 0x00, 0x28, 0x00, 0x08, 0x00, 0x3a, 0x00, 0x09, 0x00,
        0x2d, 0x00, 0x0a, 0x00, 0x3b, 0x00, 0x0b, 0x00, 0x36, 0x00, 0x0c, 0x00, 0x28, 0x00, 0x0d, 0x00,
        0x2f, 0x00, 0x0e, 0x00, 0x31, 0x00, 0x0f, 0x00, 0x35, 0x00, 0x10, 0x00, 0x34, 0x00, 0x11, 0x00,
        0x2c, 0x00, 0x12, 0x00, 0x28, 0x00, 0x13, 0x00, 0x38, 0x00, 0x14, 0x00, 0x3b, 0x00, 0x15, 0x00,
        0x2a, 0x00, 0x16, 0x00, 0x36, 0x00, 0x17, 0x00, 0x37, 0x00, 0x18, 0x00, 0x28, 0x00, 0x19, 0x00,
        0x29, 0x00, 0x1a, 0x00, 0x30, 0x00, 0x1b, 0x00, 0x3b, 0x00, 0x1c, 0x00, 0x32, 0x00, 0x1d, 0x00,
        0x3a, 0x00, 0x1e, 0x00, 0x35, 0x00, 0x1f, 0x00, 0x35, 0x00, 0x20, 0x00, 0x3b, 0x00, 0x21, 0x00,
        0x2c, 0x00, 0x22, 0x00, 0x3a, 0x00, 0x23, 0x00, 0x35, 0x00, 0x24, 0x00, 0x34, 0x00, 0x00, 0x00,
        0x2c, 0x00, 0x01, 0x00, 0x2d, 0x00, 0x02, 0x00, 0x36, 0x00, 0x03, 0x00, 0x30, 0x00, 0x04, 0x00,
        0x3b, 0x00, 0x05, 0x00, 0x32, 0x00, 0x06, 0x00, 0x2c, 0x00, 0x07, 0x00, 0x29, 0x00, 0x08, 0x00,
        0x2e, 0x00, 0x09, 0x00, 0x2e, 0x00, 0x0a, 0x00, 0x2f, 0x00, 0x0b, 0x00, 0x2b, 0x00, 0x0c, 0x00,
        0x37, 0x00, 0x0d, 0x00, 0x3b, 0x00, 0x0e, 0x00, 0x29, 0x00, 0x0f, 0x00, 0x38, 0x00, 0x10, 0x00,
        0x35, 0x00, 0x11, 0x00, 0x36, 0x00, 0x12, 0x00, 0x3b, 0x00, 0x13, 0x00, 0x29, 0x00, 0x14, 0x00,
        0x3b, 0x00, 0x15, 0x00, 0x2d, 0x00, 0x16, 0x00, 0x31, 0x00, 0x17, 0x00, 0x35, 0x00, 0x18, 0x00,
        0x33, 0x00, 0x19, 0x00, 0x2e, 0x00, 0x1a, 0x00, 0x38, 0x00, 0x1b, 0x00, 0x2a, 0x00, 0x1c, 0x00,
        0x3b, 0x00, 0x1d, 0x00, 0x2c, 0x00, 0x1e, 0x00, 0x3a, 0x00, 0x1f, 0x00, 0x33, 0x00, 0x20, 0x00,
        0x31, 0x00, 0x21, 0x00, 0x29, 0x00, 0x22, 0x00, 0x2f, 0x00, 0x23, 0x00, 0x29, 0x00, 0x24, 0x00,
        0x2a, 0x00, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00, 0x22, 0x00, 0x02, 0x00, 0x1a, 0x00, 0x03, 0x00,
        0x22, 0x00, 0x04, 0x00, 0x23, 0x00, 0x05, 0x00, 0x14, 0x00, 0x06, 0x00, 0x25, 0x00, 0x07, 0x00,
        0x23, 0x00, 0x08, 0x00, 0x20, 0x00, 0x09, 0x00, 0x18, 0x00, 0x0a, 0x00, 0x25, 0x00, 0x0b, 0x00,
        0x20, 0x00, 0x0c, 0x00, 0x1b, 0x00, 0x0d, 0x00, 0x15, 0x00, 0x0e, 0x00, 0x1b, 0x00, 0x0f, 0x00,
        0x1a, 0x00, 0x10, 0x00, 0x24, 0x00, 0x11, 0x00, 0x26, 0x00, 0x12, 0x00, 0x14, 0x00, 0x13, 0x00,
        0x21, 0x00, 0x14, 0x00, 0x21, 0x00, 0x15, 0x00, 0x26, 0x00, 0x16, 0x00, 0x1c, 0x00, 0x17, 0x00,
        0x17, 0x00, 0x18, 0x00, 0x18, 0x00, 0x19, 0x00, 0x15, 0x00, 0x1a, 0x00, 0x22, 0x00, 0x1b, 0x00,
        0x17, 0x00, 0x1c, 0x00, 0x1f, 0x00, 0x1d, 0x00, 0x27, 0x00, 0x1e, 0x00, 0x26, 0x00, 0x1f, 0x00,
        0x21, 0x00, 0x20, 0x00, 0x20, 0x00, 0x21, 0x00, 0x16, 0x00, 0x22, 0x00, 0x23, 0x00, 0x23, 0x00,
        0x1e, 0x00, 0xa8, 0x01, 0x00, 0x00, 0xfa, 0x08, 0xd5, 0x09, 0xc4, 0xd0, 0x60, 0x94, 0xfe, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x38, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x06, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xa0, 0x92, 0xff, 0xff, 0x00, 0x00,
        0x00, 0x00, 0x09, 0x00, 0x01, 0x00, 0x01, 0x00, 0x64, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xe0, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x02, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x65, 0x42, 0x00, 0x00, 0x29, 0x01,
        0x00, 0x00, 0x09, 0x00, 0x03, 0x00, 0x01, 0x00, 0x64, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xe3, 0x55, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x50, 0x79, 0x72, 0x61, 0x64, 0x6f,
        0x6e, 0x69, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x60, 0x01, 0x00, 0x01, 0x04, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x3c, 0x00, 0xa4, 0x01, 0x64, 0x00, 0x0a, 0x00, 0x1c, 0x02,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x52, 0x4b, 0x20, 0x43, 0x68, 0x72, 0x6f, 0x6d,
        0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x06, 0x08,
        0x4f, 0x02, 0x09, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x10, 0x00, 0x6c, 0x00, 0x48, 0x03, 0x64, 0x00, 0x20, 0x00, 0x0e, 0x04, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x65, 0x74, 0x61, 0x6c, 0x69, 0x6e, 0x65, 0x20, 0x4b,
        0x65, 0x6c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x05, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00,
        0x08, 0x00, 0x08, 0x00, 0x9e, 0x00, 0x64, 0x00, 0x10, 0x00, 0x06, 0x01, 0x00, 0x00, 0xf4, 0x01,
        0x01, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x4c, 0x61, 0x78, 0x69, 0x6d, 0x6f, 0x73, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x23, 0x00, 0xa4, 0x01, 0x09, 0x00,
        0x11, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xf2, 0x00, 0x00, 0x00, 0x01, 0x00, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x17, 0x00, 0x02, 0x00, 0x20, 0x00, 0x03, 0x00, 0x22, 0x00, 0x00, 0x00,
        0x17, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1a, 0x00, 0xb8, 0x02, 0x00, 0x00, 0x23, 0x0a,
        0xde, 0x09, 0xc9, 0x7a, 0x3d, 0x6d, 0x60, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
        0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x3e, 0x00,
        0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x88, 0x02,
        0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x03, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0xe0, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x03, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x65, 0x42, 0x00, 0x00, 0x29, 0x01,
        0x00, 0x00, 0x09, 0x00, 0x04, 0x00, 0x02, 0x00, 0x64, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0xe3, 0x55, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x04, 0x00, 0x06, 0x00, 0x02, 0x00,
        0x64, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xa0, 0x92, 0xff, 0xff, 0x00, 0x00,
        0x00, 0x00, 0x52, 0x4b, 0x20, 0x42, 0x61, 0x72, 0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x6e, 0x00, 0x2b, 0x00, 0x09, 0x00, 0x51, 0x00,
        0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0c, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x78, 0x00, 0x64, 0x00, 0x01, 0x00, 0x83, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x52, 0x4b, 0x20, 0x47, 0x69, 0x62, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x0b, 0x04, 0xc9, 0x00, 0x09, 0x00, 0x53, 0x00, 0x01, 0x00,
        0x0a, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x36, 0x00, 0x6f, 0x01,
        0x64, 0x00, 0x10, 0x00, 0xf5, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x52, 0x4b,
        0x20, 0x4e, 0x69, 0x74, 0x72, 0x6f, 0x67, 0x65, 0x6e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x00, 0x00, 0x0b, 0x04, 0x36, 0x01, 0x09, 0x00, 0x53, 0x00, 0x02, 0x00, 0x0a, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x36, 0x00, 0xe2, 0x01, 0x64, 0x00,
        0x10, 0x00, 0x7c, 0x02, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0xff, 0xff, 0x54, 0x68, 0x65, 0x74,
        0x61, 0x20, 0x56, 0x49, 0x49, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x00, 0x00, 0x00, 0x00, 0xba, 0x01, 0x09, 0x00, 0x00, 0x00, 0x01, 0x00, 0x07, 0x00, 0x0a, 0x00,
        0x06, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x26, 0x00, 0xe6, 0x00, 0x64, 0x00, 0x1a, 0x00,
        0xca, 0x01, 0x00, 0x00, 0xf4, 0x01, 0x01, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x56, 0x61, 0x6e,
        0x64, 0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
        0x06, 0x08, 0xb4, 0x02, 0x09, 0x00, 0x4f, 0x00, 0x01, 0x00, 0x07, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x69, 0x00, 0x21, 0x03, 0x64, 0x00, 0x20, 0x00, 0xe7, 0x03,
        0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x52, 0x4b, 0x20, 0x53, 0x74, 0x72, 0x6f, 0x6e,
        0x74, 0x69, 0x75, 0x6d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x06, 0x08,
        0xce, 0x03, 0x09, 0x00, 0x4f, 0x00, 0x01, 0x00, 0x07, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x10, 0x00, 0x5f, 0x00, 0x53, 0x03, 0x64, 0x00, 0x20, 0x00, 0x19, 0x04, 0x00, 0x00,
        0xf4, 0x01, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x75, 0x72, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x13, 0x03, 0x96, 0x01,
        0x04, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x59, 0x00, 0x0a, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x99, 0x02, 0x64, 0x00, 0x01, 0x00, 0xa2, 0x03, 0x00, 0x00, 0xf4, 0x01,
        0x00, 0x00, 0xff, 0xff, 0x47, 0x72, 0x61, 0x75, 0x74, 0x76, 0x6f, 0x72, 0x6e, 0x69, 0x78, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x13, 0x03, 0xd1, 0x02, 0x04, 0x00,
        0x23, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x64, 0x00, 0x0a, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x99, 0x02, 0x64, 0x00, 0x01, 0x00, 0xa2, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00,
        0xff, 0xff, 0x06, 0x00, 0x32, 0x00, 0x07, 0x00, 0x2a, 0x00, 0x06, 0x00, 0x1f, 0x00, 0x07, 0x00,
        0x1c, 0x00, 0x06, 0x00, 0x2f, 0x00, 0x07, 0x00, 0x28, 0x00, 0x00, 0x00, 0x33, 0x00, 0x01, 0x00,
        0x32, 0x00, 0x02, 0x00, 0x3a, 0x00, 0x03, 0x00, 0x2a, 0x00, 0x04, 0x00, 0x2a, 0x00, 0x05, 0x00,
        0x2c, 0x00
    };
}

/** Simple functionality test. */
AFL_TEST("game.vcr.flak.Database", a)
{
    game::vcr::flak::Database testee;
    game::config::HostConfiguration config;
    a.checkEqual("01. getNumBattles", testee.getNumBattles(), 0U);
    a.checkNull("02. getBattle", testee.getBattle(0));

    afl::io::ConstMemoryStream ms(FILE_CONTENT);
    afl::charset::CodepageCharset cs(afl::charset::g_codepageLatin1);
    afl::string::NullTranslator tx;
    AFL_CHECK_SUCCEEDS(a("11. load"), testee.load(ms, cs, tx));

    a.checkEqual("21. getNumBattles", testee.getNumBattles(), 3U);
    a.checkEqual("22. getNumObjects", testee.getBattle(0)->getNumObjects(), 68U);
    a.checkEqual("23. getNumObjects", testee.getBattle(2)->getNumObjects(), 8U);
    a.checkEqual("24. getObject",     testee.getBattle(2)->getObject(7, false)->getName(), "Grautvornix");
    a.checkEqual("25. getTimestamp",  testee.getTimestamp().getTimestampAsString(), "09-22-200623:00:51");

    // Verify save.
    // Skip header because that contains the player assignment that we do not reproduce.
    const size_t SKIP = sizeof(game::vcr::flak::structures::Header);
    afl::io::InternalStream out;
    testee.save(out, 0, 3, config, cs);
    a.checkEqual("31. save size", out.getContent().size(), sizeof(FILE_CONTENT));
    a.checkEqualContent("32. content", out.getContent().subrange(SKIP), afl::base::ConstBytes_t(FILE_CONTENT).subrange(SKIP));
}
