start('c2export', 'PCC2 Data Export');

section('Synopsis',
        paragraph_synopsis('<b>c2export -h</b>'),
        paragraph_synopsis('<b>c2export</b> [<b>-</b><i>opts</i>] [<b>-f</b> <i>F</i><b>@</b><i>W</i>... ] [<b>-S</b>|<b>-P</b>|<b>-A</b> <i>OBJECT</i>] [<b>-t</b> <i>TYPE</i>] <i>DIR</i> [<i>ROOT</i>] <i>PLAYER</i>'));

section('Description',
        paragraph_text('<i>c2export</i> exports VGA Planets&trade; data.',
                       'It supports a variety of output formats, both human-readable and machine-readable.'),
        paragraph_text('By default, output goes to standard output; see <link>pcc2(6)</link> for details.',
                       'You can tell <i>c2export</i> to write to a file (<b>-o</b>),',
                       'and you can specify the character set to use for that file (<b>-O</b>).'),
        paragraph_text('By default, <i>c2export</i> creates a report containing Id and Name of each object.',
                       'You can select different fields (<b>-f</b>).'),
        paragraph_text("<i>c2export</i> reads <i>PLAYER</i>'s files from the specified game directory <i>DIR</i>.",
                       "You can omit the directory to read from the current directory;",
                       "you can omit the player number if there is just one player's data.",
                       "Player data can be unpacked, but doesn't have to (just as with the PCC2 client)."),
        paragraph_text("<i>c2export</i> can export all scalar data (numbers, strings), such as names, amounts, etc.",
                       "Some properties are arrays or complex types, for example, a starbase's storage.",
                       "Those will show a placeholder such as \"#&lt;array&gt;\" in export.",
                       "An exception is the JSON exporter which will export simple arrays as expected."));

section('Options',
        paragraph_default_help(';'),
        paragraph_detail('<b>-C</b> <i>CHARSET</i>',
                         paragraph_text('Set <i>character set</i> for game file content;')),
        paragraph_detail('<b>-f</b> <i>name</i><b>@</b><i>width</i>,...',
                         paragraph_text('Add <i>field</i> to output.',
                                        'Valid field names are all CCScript properties of the desired object type,',
                                        'such as NAME, ID, CARGO.N, OWNER$, COMMENT, etc.'),
                         paragraph_text('Some output formats require fixed-width columns.',
                                        "You can override <i>c2export</i>'s default column width using \"@\"."),
                         paragraph_text('You can use multiple <b>-f</b> options.',
                                        'You can add multiple fields with one <b>-f</b> option by separating them with commas.',
                                        'The default, if no <b>-f</b> option is specified, is <b>ID@5,NAME@30</b>;')),
        paragraph_detail('<b>-S</b>',
                         paragraph_text('Export <i>ships</i> (same as <b>-A SHIP</b>);')),
        paragraph_detail('<b>-P</b>',
                         paragraph_text('Export <i>planets</i> (same as <b>-A PLANET</b>);')),
        paragraph_detail('<b>-A</b> <i>OBJECT</i>',
                         paragraph_text('Export specified object type.',
                                        'The parameter is a CCScript <i>array</i> name (e.g. SHIP, PLANET, HULL, ...);')),
        paragraph_detail('<b>-t</b> <i>TYPE</i>',
                         paragraph_text('Specify output file <i>type</i>.',
                                        'See below;')),
        paragraph_detail('<b>-o</b> <i>FILE</i>',
                         paragraph_text('Specify <i>output file</i> name.',
                                        'By default, output goes to standard output;')),
        paragraph_detail('<b>-O</b> <i>CHARSET</i>',
                         paragraph_text('Specify output file character set.',
                                        'This option is only interpreted when <b>-o</b> is also given;')),
        paragraph_detail('<b>-F</b>',
                         paragraph_text('Output list of <i>fields</i> instead of game data.',
                                        'For example, when used with <b>-P</b>, this will produce a list of fields supported by planets ("planets have a NAME, ID, ..."),',
                                        'instead of the actual fields for each planet ("there is a planet called Castor, one called Mira, ...").'),
                         paragraph_text('Note that game data still needs to be loaded because it contains information about which fields are present.'),
                         paragraph_text('You need not specify a <b>-f</b> option when you use <b>-F</b>, but if you do, you can use the fields NAME, ID, and TYPE;')),
        paragraph_detail('<b>-c</b> <i>FILE.ccx</i>',
                         paragraph_text('Read parameters from a file (<i>configuration</i>).',
                                        'The file can specify field names, an output character set, and a file type; see below;')),
        paragraph_detail('<b>-v</b>',
                         paragraph_text('Verbose mode.')));

section('Output File Types',
        paragraph_detail('text',
                         paragraph_text('Generates a simple plain-text table.',
                                        'The first line contains the field names,',
                                        'followed by one line per object with the values;')),
        paragraph_detail('table',
                         paragraph_text('Similar to <b>text</b>, but draws a table using nice ASCII art boxes;')),
        paragraph_detail('csv',
                         paragraph_text('Comma-separated values.',
                                        'Those files can be imported into spreadsheet programs like Excel;')),
        paragraph_detail('tsv',
                         paragraph_text('Tab-separated values (otherwise, same as <b>csv</b>);')),
        paragraph_detail('ssv',
                         paragraph_text('Semicolon-separated values (otherwise, same as <b>csv</b>);')),
        paragraph_detail('json',
                         paragraph_text('JSON (JavaScript object literal);')),
        paragraph_detail('html',
                         paragraph_text('HTML. Creates a document containing one large table;')),
        paragraph_detail('dbf',
                         paragraph_text('dBASE&reg; files.',
                                        'Those files can be used with database programs.',
                                        'When you use type <b>dbf</b>, you must also specify a <b>-o</b> option.',
                                        'Database files cannot be written to standard output.')));

section('Configuration File Format',
        paragraph_text('Configuration files conventionally have a <fn>.ccx</fn> extension.',
                       'You can create these files using the PCC graphical interface, or manually.',
                       'Configuration files are plain text files with lines in standard "key=value" format.',
                       'Recognized keys:'),
        paragraph_detail('<b>Fields=</b><i>name@width,...</i>',
                         paragraph_text('Add fields (same as <b>-f</b> option);')),
        paragraph_detail('<b>Charset=</b><i>charset</i>',
                         paragraph_text('Set character set (same as <b>-O</b> option);')),
        paragraph_detail('<b>Format=</b><i>type</i>',
                         paragraph_text('Set output file format (same as <b>-t</b> option).')),
        paragraph_text('Lines starting with a "#" are interpreted as comments and ignored.'),
        paragraph_text('Parameters read from the file add to (Fields) or override (Charset, Format) those given on the command line before the <b>-c</b> option,',
                       'and can themselves be added to or overridden by command-line options given after it.'));

section('Environment', paragraph_default_environment());

section('Limitations',
        paragraph_text('The output character set (<b>-O</b>) option will only be interpreted when <b>-o</b> is also used to direct output to a file.',
                       'Standard output will always use system rules as documented in <link>pcc2(6)</link>,',
                       "even when redirected to a file using the operating system's \">\" operator."));

section('Author', paragraph_default_author());

section('See Also', paragraph_link_list('pcc2(6)'));
